/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.VWScenarioResourceDefinition;
import filenet.sim.api.VWScenarioRoleAssignment;
import filenet.sim.api.VWScenarioValidationError;
import filenet.vw.api.VWException;
import filenet.vw.base.VWString;
import java.io.Serializable;
import java.util.Vector;

public final class VWScenarioResourceAssignment
implements Cloneable,
Serializable {
    private VWScenarioRoleAssignment m_role = null;
    private String m_resourceName = null;
    private float m_performance = 1.0f;

    protected VWScenarioResourceAssignment(VWScenarioResourceDefinition resource, float performance, VWScenarioRoleAssignment role) throws VWException {
        this.m_role = role;
        this.setPerformance(performance);
        this.m_resourceName = resource.getName();
        resource.addResourceAssignmentToCache(this);
    }

    public String getResourceName() {
        return this.m_resourceName;
    }

    protected void setResourceName(String resourceName) throws VWException {
        if (resourceName == null) {
            throw new VWException("sim.api.VWScenarioResourceAssignment.NullResourceNameParameter", "The resourceName parameter can not be null.");
        }
        if (this.m_role.hasResource(resourceName)) {
            throw new VWException("sim.api.VWScenarioResourceAssignment.ResourceAssignmentAlreadyExists", "Resource name {0} is invalid (a resource with that name has already been assigned to this role).", resourceName);
        }
        if (!this.m_role.getShift().getScenario().hasResource(resourceName)) {
            throw new VWException("sim.api.VWScenarioResourceAssignment.InvalidResourcename", "Resource name {0} is invalid (a resource with that name does not exist within the scenario.", resourceName);
        }
        this.m_role.updateResource(this.getResourceName(), resourceName);
        this.m_resourceName = resourceName;
    }

    public float getPerformance() {
        return this.m_performance;
    }

    public void setPerformance(float performance) throws VWException {
        if (performance <= 0.0f) {
            throw new VWException("sim.api.VWScenarioResourceAssignment.InvalidPerformance", "The resource performance factor must be greater than zero.");
        }
        this.m_performance = performance;
    }

    public String toString() {
        return this.getResourceName();
    }

    public void validate(Vector EDefVector) throws VWException {
        if (!this.getRole().getShift().getScenario().hasResource(this.getResourceName())) {
            String shiftName = this.getRole().getShift().getName();
            VWString theMessage = new VWString("sim.api.VWScenarioResourceAssignment.InvalidResourceAssignment", "Invalid resource {0} assigned to shift {1}. The resource has not been defined for this scenario.", this.getResourceName(), shiftName);
            VWScenarioValidationError theError = new VWScenarioValidationError(5, 1, shiftName, null, theMessage.toString());
            EDefVector.addElement(theError);
        }
    }

    protected Object clone() {
        VWScenarioResourceAssignment clone = null;
        try {
            clone = (VWScenarioResourceAssignment)super.clone();
            this.getRole().getShift().getScenario().getResource(this.getResourceName()).addResourceAssignmentToCache(clone);
        }
        catch (VWException e) {
            return null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public VWScenarioRoleAssignment getRole() {
        return this.m_role;
    }

    protected void setRole(VWScenarioRoleAssignment role) {
        this.m_role = role;
    }

    protected void releaseReferences() throws VWException {
        this.getRole().getShift().getScenario().getResource(this.getResourceName()).removeResourceAssignmentFromCache(this);
    }
}

